/*
 * Decompiled with CFR 0.152.
 */
package org.dyno.visual.swing.layouts;

import java.awt.Container;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public abstract class LayoutStyle {
    private static LayoutStyle singleton5 = new DefaultLayoutStyle();
    private static LayoutStyle singleton6;

    public static LayoutStyle getInstance() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6")) {
            if (singleton6 == null) {
                singleton6 = new Java6LayoutStyle();
            }
            return singleton6;
        }
        return singleton5;
    }

    public abstract int getContainerGap(JComponent var1, int var2, Container var3);

    public abstract int getPreferredGap(JComponent var1, JComponent var2, ComponentPlacement var3, int var4, Container var5);

    public static enum ComponentPlacement {
        RELATED,
        UNRELATED,
        INDENT;

    }

    private static class DefaultLayoutStyle
    extends LayoutStyle {
        private DefaultLayoutStyle() {
        }

        @Override
        public int getContainerGap(JComponent component, int position, Container parent) {
            return 12;
        }

        @Override
        public int getPreferredGap(JComponent component1, JComponent component2, ComponentPlacement type, int position, Container parent) {
            switch (type) {
                case RELATED: {
                    return 6;
                }
                case UNRELATED: {
                    return 12;
                }
                case INDENT: {
                    return 12;
                }
            }
            return 12;
        }
    }

    private static class Java6LayoutStyle
    extends LayoutStyle {
        private static Class java6LayoutStyleClass;
        private static Class java6ComponentPlacementClass;
        private Object style;
        private static Method getContainerGap;
        private static Method getPreferredGap;
        private static Method valueOf;

        public Java6LayoutStyle() {
            if (java6LayoutStyleClass == null) {
                try {
                    java6LayoutStyleClass = Class.forName("javax.swing.LayoutStyle");
                    java6ComponentPlacementClass = Class.forName("javax.swing.LayoutStyle$ComponentPlacement");
                    getContainerGap = java6LayoutStyleClass.getMethod("getContainerGap", JComponent.class, Integer.TYPE, Container.class);
                    getPreferredGap = java6LayoutStyleClass.getMethod("getPreferredGap", JComponent.class, JComponent.class, java6ComponentPlacementClass, Integer.TYPE, Container.class);
                    valueOf = java6ComponentPlacementClass.getMethod("valueOf", String.class);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            try {
                Method method = java6LayoutStyleClass.getMethod("getInstance", new Class[0]);
                this.style = method.invoke(null, new Object[0]);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }

        @Override
        public int getContainerGap(JComponent component, int position, Container parent) {
            try {
                return (Integer)getContainerGap.invoke(this.style, component, position, parent);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return 12;
            }
        }

        @Override
        public int getPreferredGap(JComponent component1, JComponent component2, ComponentPlacement type, int position, Container parent) {
            try {
                Object enumType = valueOf.invoke(null, type.name());
                return (Integer)getPreferredGap.invoke(this.style, component1, component2, enumType, position, parent);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return 12;
            }
        }
    }
}

