/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.jarinjarloader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jdt.internal.jarinjarloader.RsrcURLStreamHandlerFactory;

public class JarRsrcLoader {
    public static void main(String[] args) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, IOException {
        ManifestInfo mi2 = JarRsrcLoader.getManifestInfo();
        ClassLoader cl2 = Thread.currentThread().getContextClassLoader();
        URL.setURLStreamHandlerFactory(new RsrcURLStreamHandlerFactory(cl2));
        URL[] rsrcUrls = new URL[mi2.rsrcClassPath.length];
        int i2 = 0;
        while (i2 < mi2.rsrcClassPath.length) {
            String rsrcPath = mi2.rsrcClassPath[i2];
            rsrcUrls[i2] = rsrcPath.endsWith("/") ? new URL("rsrc:" + rsrcPath) : new URL("jar:rsrc:" + rsrcPath + "!/");
            ++i2;
        }
        URLClassLoader jceClassLoader = new URLClassLoader(rsrcUrls, JarRsrcLoader.getParentClassLoader());
        Thread.currentThread().setContextClassLoader(jceClassLoader);
        Class<?> c2 = Class.forName(mi2.rsrcMainClass, true, jceClassLoader);
        Method main = c2.getMethod("main", args.getClass());
        main.invoke(null, new Object[]{args});
    }

    private static ClassLoader getParentClassLoader() throws InvocationTargetException, IllegalAccessException {
        try {
            Method platformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", null);
            return (ClassLoader)platformClassLoader.invoke(null, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static ManifestInfo getManifestInfo() throws IOException {
        Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resEnum.hasMoreElements()) {
            try {
                URL url = resEnum.nextElement();
                InputStream is2 = url.openStream();
                if (is2 == null) continue;
                ManifestInfo result = new ManifestInfo();
                Manifest manifest = new Manifest(is2);
                Attributes mainAttribs = manifest.getMainAttributes();
                result.rsrcMainClass = mainAttribs.getValue("Rsrc-Main-Class");
                String rsrcCP = mainAttribs.getValue("Rsrc-Class-Path");
                if (rsrcCP == null) {
                    rsrcCP = "";
                }
                result.rsrcClassPath = JarRsrcLoader.splitSpaces(rsrcCP);
                if (result.rsrcMainClass == null || result.rsrcMainClass.trim().equals("")) continue;
                return result;
            }
            catch (Exception exception) {}
        }
        System.err.println("Missing attributes for JarRsrcLoader in Manifest (Rsrc-Main-Class, Rsrc-Class-Path)");
        return null;
    }

    private static String[] splitSpaces(String line) {
        if (line == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int firstPos = 0;
        while (firstPos < line.length()) {
            int lastPos = line.indexOf(32, firstPos);
            if (lastPos == -1) {
                lastPos = line.length();
            }
            if (lastPos > firstPos) {
                result.add(line.substring(firstPos, lastPos));
            }
            firstPos = lastPos + 1;
        }
        return result.toArray(new String[result.size()]);
    }

    private static class ManifestInfo {
        String rsrcMainClass;
        String[] rsrcClassPath;

        private ManifestInfo() {
        }
    }
}

