/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Arrays;
import org.json.JSONException;

public class Kim {
    private byte[] bytes = null;
    private int hashcode = 0;
    public int length = 0;
    private String string = null;

    public Kim(byte[] byArray, int n2, int n3) {
        int n4 = 1;
        this.hashcode = 0;
        this.length = n3 - n2;
        if (this.length > 0) {
            this.bytes = new byte[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n5 = byArray[i2 + n2] & 0xFF;
                this.hashcode += (n4 += n5);
                this.bytes[i2] = (byte)n5;
            }
            this.hashcode += n4 << 16;
        }
    }

    public Kim(byte[] byArray, int n2) {
        this(byArray, 0, n2);
    }

    public Kim(Kim kim2, int n2, int n3) {
        this(kim2.bytes, n2, n3);
    }

    public Kim(String string) {
        int n2 = string.length();
        this.hashcode = 0;
        this.length = 0;
        if (n2 > 0) {
            int n3;
            int n4;
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = string.charAt(n5);
                if (n4 <= 127) {
                    ++this.length;
                    continue;
                }
                if (n4 <= 16383) {
                    this.length += 2;
                    continue;
                }
                if (n4 >= 55296 && n4 <= 57343) {
                    n3 = string.charAt(++n5);
                    if (n4 > 56319 || n3 < 56320 || n3 > 57343) {
                        throw new JSONException("Bad UTF16");
                    }
                }
                this.length += 3;
            }
            this.bytes = new byte[this.length];
            n5 = 0;
            n3 = 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n6 = string.charAt(i2);
                if (n6 <= 127) {
                    this.bytes[n5] = (byte)n6;
                    this.hashcode += (n3 += n6);
                    ++n5;
                    continue;
                }
                if (n6 <= 16383) {
                    n4 = 0x80 | n6 >>> 7;
                    this.bytes[n5] = (byte)n4;
                    this.hashcode += (n3 += n4);
                    n4 = n6 & 0x7F;
                    this.bytes[++n5] = (byte)n4;
                    this.hashcode += (n3 += n4);
                    ++n5;
                    continue;
                }
                if (n6 >= 55296 && n6 <= 56319) {
                    n6 = ((n6 & 0x3FF) << 10 | string.charAt(++i2) & 0x3FF) + 65536;
                }
                n4 = 0x80 | n6 >>> 14;
                this.bytes[n5] = (byte)n4;
                this.hashcode += (n3 += n4);
                n4 = 0x80 | n6 >>> 7 & 0xFF;
                this.bytes[++n5] = (byte)n4;
                this.hashcode += (n3 += n4);
                n4 = n6 & 0x7F;
                this.bytes[++n5] = (byte)n4;
                this.hashcode += (n3 += n4);
                ++n5;
            }
            this.hashcode += n3 << 16;
        }
    }

    public int characterAt(int n2) {
        int n3 = this.get(n2);
        if ((n3 & 0x80) == 0) {
            return n3;
        }
        int n4 = this.get(n2 + 1);
        if ((n4 & 0x80) == 0) {
            int n5 = (n3 & 0x7F) << 7 | n4;
            if (n5 > 127) {
                return n5;
            }
        } else {
            int n6 = this.get(n2 + 2);
            int n7 = (n3 & 0x7F) << 14 | (n4 & 0x7F) << 7 | n6;
            if ((n6 & 0x80) == 0 && n7 > 16383 && n7 <= 0x10FFFF && (n7 < 55296 || n7 > 57343)) {
                return n7;
            }
        }
        throw new JSONException("Bad character at " + n2);
    }

    public static int characterSize(int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new JSONException("Bad character " + n2);
        }
        return n2 <= 127 ? 1 : (n2 <= 16383 ? 2 : 3);
    }

    public int copy(byte[] byArray, int n2) {
        System.arraycopy(this.bytes, 0, byArray, n2, this.length);
        return n2 + this.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Kim)) {
            return false;
        }
        Kim kim2 = (Kim)object;
        if (this == kim2) {
            return true;
        }
        if (this.hashcode != kim2.hashcode) {
            return false;
        }
        return Arrays.equals(this.bytes, kim2.bytes);
    }

    public int get(int n2) {
        if (n2 < 0 || n2 > this.length) {
            throw new JSONException("Bad character at " + n2);
        }
        return this.bytes[n2] & 0xFF;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        if (this.string == null) {
            int n2;
            int n3 = 0;
            char[] cArray = new char[this.length];
            for (int i2 = 0; i2 < this.length; i2 += Kim.characterSize(n2)) {
                n2 = this.characterAt(i2);
                if (n2 < 65536) {
                    cArray[n3] = (char)n2;
                    ++n3;
                    continue;
                }
                cArray[n3] = (char)(0xD800 | n2 - 65536 >>> 10);
                cArray[++n3] = (char)(0xDC00 | n2 & 0x3FF);
                ++n3;
            }
            this.string = new String(cArray, 0, n3);
        }
        return this.string;
    }
}

